/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.widget.hint;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.function.Supplier;
import me.shedaniel.clothconfig2.ClothConfigInitializer;
import me.shedaniel.clothconfig2.api.animator.NumberAnimator;
import me.shedaniel.clothconfig2.api.animator.ValueAnimator;
import me.shedaniel.clothconfig2.api.scroll.ScrollingContainer;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.widgets.CloseableScissors;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.WidgetWithBounds;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.impl.client.gui.ScreenOverlayImpl;
import me.shedaniel.rei.impl.client.gui.widget.hint.HintsContainerWidget;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;

public class HintWidget
extends WidgetWithBounds {
    private static final int MAX_WIDTH = 180;
    private static final int MAX_HEIGHT = 130;
    private final HintsContainerWidget parent;
    private final Rectangle bounds = new Rectangle();
    private final Rectangle okayBounds = new Rectangle();
    private final int margin;
    private final Supplier<Point> point;
    private final String uuid;
    private final Collection<? extends FormattedText> lines;
    private List<List<FormattedCharSequence>> wrapped;
    private final NumberAnimator<Double> scroll = ValueAnimator.ofDouble((double)0.0);
    private int contentHeight;

    public HintWidget(HintsContainerWidget parent, int margin, Supplier<Point> point, String uuid, Collection<? extends FormattedText> lines) {
        this.parent = parent;
        this.margin = margin;
        this.point = point;
        this.uuid = uuid;
        this.lines = lines;
        this.recalculateBounds();
    }

    void recalculateBounds() {
        int screenWidth = this.minecraft.m_91268_().m_85445_();
        int screenHeight = this.minecraft.m_91268_().m_85444_();
        int width = Mth.m_14045_((int)CollectionUtils.mapAndMax(this.lines, l -> CollectionUtils.max(this.font.m_92923_(l, 172), Comparator.comparingLong(value -> this.font.m_92724_(value) + 8)).map(value -> this.font.m_92724_(value) + 8).orElse(0), Comparator.naturalOrder()).orElse(0), (int)60, (int)180);
        Point point = this.point.get();
        int spaceLeft = Math.max(point.x - 4, 0);
        int spaceRight = Math.max(screenWidth - point.x - 4, 0);
        this.bounds.width = Math.min(width, Math.max(spaceLeft, spaceRight));
        this.bounds.x = spaceRight >= spaceLeft ? point.x + this.margin : point.x - this.margin - this.bounds.width;
        this.wrapped = CollectionUtils.map(this.lines, l -> this.font.m_92923_(l, this.bounds.width - 8));
        int height = 17;
        for (List<FormattedCharSequence> formattedCharSequences : this.wrapped) {
            height += formattedCharSequences.size() * 9;
            height += 2;
        }
        this.contentHeight = height - 9 - 2;
        this.bounds.height = Math.min(height, 130);
        this.bounds.y = Mth.m_14045_((int)(point.y + this.margin - this.bounds.height), (int)4, (int)(screenHeight - this.bounds.height - 4));
    }

    @Override
    public Rectangle getBounds() {
        return this.bounds;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void m_6305_(PoseStack poses, int mouseX, int mouseY, float delta) {
        int color1;
        this.scroll.setTarget(ScrollingContainer.handleBounceBack((double)((Double)this.scroll.target()), (double)(this.contentHeight - (this.bounds.height - 8 - 9) - 9), (float)delta, (double)0.08));
        this.scroll.update((double)delta);
        RenderSystem.m_69465_();
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferBuilder = tesselator.m_85915_();
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        poses.m_85836_();
        poses.m_85837_(0.0, 0.0, 450.0);
        Matrix4f pose = poses.m_85850_().m_85861_();
        int background = -267386864;
        int color2 = color1 = 0x505000FF;
        int x = this.bounds.x;
        int y = this.bounds.y;
        int width = this.bounds.width;
        int height = this.bounds.height;
        HintWidget.m_93123_((Matrix4f)pose, (BufferBuilder)bufferBuilder, (int)x, (int)(y - 1), (int)(x + width), (int)y, (int)400, (int)background, (int)background);
        HintWidget.m_93123_((Matrix4f)pose, (BufferBuilder)bufferBuilder, (int)x, (int)(y + height), (int)(x + width), (int)(y + height + 1), (int)400, (int)background, (int)background);
        HintWidget.m_93123_((Matrix4f)pose, (BufferBuilder)bufferBuilder, (int)x, (int)y, (int)(x + width), (int)(y + height), (int)400, (int)background, (int)background);
        HintWidget.m_93123_((Matrix4f)pose, (BufferBuilder)bufferBuilder, (int)(x - 1), (int)y, (int)x, (int)(y + height), (int)400, (int)background, (int)background);
        HintWidget.m_93123_((Matrix4f)pose, (BufferBuilder)bufferBuilder, (int)(x + width), (int)y, (int)(x + width + 1), (int)(y + height), (int)400, (int)background, (int)background);
        HintWidget.m_93123_((Matrix4f)pose, (BufferBuilder)bufferBuilder, (int)x, (int)(y + 1), (int)(x + 1), (int)(y + height - 1), (int)400, (int)color1, (int)color2);
        HintWidget.m_93123_((Matrix4f)pose, (BufferBuilder)bufferBuilder, (int)(x + width - 1), (int)(y + 1), (int)(x + width), (int)(y + height - 1), (int)400, (int)color1, (int)color2);
        HintWidget.m_93123_((Matrix4f)pose, (BufferBuilder)bufferBuilder, (int)x, (int)y, (int)(x + width), (int)(y + 1), (int)400, (int)color1, (int)color1);
        HintWidget.m_93123_((Matrix4f)pose, (BufferBuilder)bufferBuilder, (int)x, (int)(y + height - 1), (int)(x + width), (int)(y + height), (int)400, (int)color2, (int)color2);
        bufferBuilder.m_85721_();
        BufferUploader.m_85761_((BufferBuilder)bufferBuilder);
        int lineY = y + 4;
        try (CloseableScissors scissors = Widget.scissor(pose, new Rectangle(x + 4, y + 4, width - 8, height - 8 - 9 - 2));){
            for (List<FormattedCharSequence> block : this.wrapped) {
                for (FormattedCharSequence line : block) {
                    this.font.m_92744_(poses, line, (float)(x + 4), (float)(lineY - this.scroll.intValue()), -1);
                    lineY += 9;
                }
                lineY += 2;
            }
        }
        TranslatableComponent okay = new TranslatableComponent("gui.ok");
        int okayWidth = this.font.m_92852_((FormattedText)okay);
        int midPoint = x + 4 + (width - 4) / 2;
        this.okayBounds.setBounds(midPoint - okayWidth / 2, lineY, okayWidth, 9);
        if (this.okayBounds.contains(mouseX, mouseY)) {
            okay = okay.m_130940_(ChatFormatting.UNDERLINE);
        }
        this.font.m_92763_(poses, (Component)okay, (float)this.okayBounds.x, (float)this.okayBounds.y, -6710887);
        poses.m_85849_();
        RenderSystem.m_69482_();
        if (this.bounds.contains(mouseX, mouseY)) {
            ScreenOverlayImpl.getInstance().clearTooltips();
        }
    }

    public List<? extends GuiEventListener> m_6702_() {
        return List.of();
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.okayBounds.contains(mouseX, mouseY)) {
            this.parent.removeHint(this);
            Widgets.produceClickSound();
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        if (this.containsMouse(mouseX, mouseY)) {
            this.scroll.setTo((Double)this.scroll.target() + ClothConfigInitializer.getScrollStep() * amount * ((double)this.getBounds().getWidth() / -50.0), ClothConfigInitializer.getScrollDuration());
            return true;
        }
        return super.m_6050_(mouseX, mouseY, amount);
    }
}

